/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemMug;
import lotr.common.quest.LOTRMiniQuest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class LOTRMiniQuestCollect
extends LOTRMiniQuest {
    public ItemStack collectItem;
    public int collectTarget;
    public int amountGiven;

    public LOTRMiniQuestCollect(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.collectItem != null) {
            NBTTagCompound itemData = new NBTTagCompound();
            this.collectItem.func_77955_b(itemData);
            nbt.func_74782_a("Item", (NBTBase)itemData);
        }
        nbt.func_74768_a("Target", this.collectTarget);
        nbt.func_74768_a("Given", this.amountGiven);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("Item")) {
            NBTTagCompound itemData = nbt.func_74775_l("Item");
            this.collectItem = ItemStack.func_77949_a((NBTTagCompound)itemData);
        }
        this.collectTarget = nbt.func_74762_e("Target");
        this.amountGiven = nbt.func_74762_e("Given");
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.collectItem != null && this.collectTarget > 0;
    }

    @Override
    public String getQuestObjective() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.collect", (Object[])new Object[]{this.collectTarget, this.collectItem.func_82833_r()});
    }

    @Override
    public String getObjectiveInSpeech() {
        return this.collectTarget + " " + this.collectItem.func_82833_r();
    }

    @Override
    public String getProgressedObjectiveInSpeech() {
        return this.collectTarget - this.amountGiven + " " + this.collectItem.func_82833_r();
    }

    @Override
    public String getQuestProgress() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.collect.progress", (Object[])new Object[]{this.amountGiven, this.collectTarget});
    }

    @Override
    public String getQuestProgressShorthand() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.progressShort", (Object[])new Object[]{this.amountGiven, this.collectTarget});
    }

    @Override
    public float getCompletionFactor() {
        return (float)this.amountGiven / (float)this.collectTarget;
    }

    @Override
    public ItemStack getQuestIcon() {
        return this.collectItem;
    }

    @Override
    public void onInteract(EntityPlayer entityplayer, LOTREntityNPC npc) {
        int prevAmountGiven = this.amountGiven;
        ArrayList<Integer> slotNumbers = new ArrayList<Integer>();
        slotNumbers.add(entityplayer.field_71071_by.field_70461_c);
        for (int slot = 0; slot < entityplayer.field_71071_by.field_70462_a.length; ++slot) {
            if (slotNumbers.contains(slot)) continue;
            slotNumbers.add(slot);
        }
        Iterator slot = slotNumbers.iterator();
        while (slot.hasNext()) {
            int slot2 = (Integer)slot.next();
            ItemStack itemstack = entityplayer.field_71071_by.field_70462_a[slot2];
            if (this.isQuestItem(itemstack)) {
                int amountRemaining = this.collectTarget - this.amountGiven;
                if (itemstack.field_77994_a >= amountRemaining) {
                    itemstack.field_77994_a -= amountRemaining;
                    if (itemstack.field_77994_a <= 0) {
                        itemstack = null;
                    }
                    entityplayer.field_71071_by.func_70299_a(slot2, itemstack);
                    this.amountGiven += amountRemaining;
                } else {
                    this.amountGiven += itemstack.field_77994_a;
                    entityplayer.field_71071_by.func_70299_a(slot2, null);
                }
            }
            if (this.amountGiven < this.collectTarget) continue;
            this.complete(entityplayer, npc);
            break;
        }
        if (this.amountGiven > prevAmountGiven && !this.isCompleted()) {
            this.updateQuest();
        }
        if (!this.isCompleted()) {
            this.sendProgressSpeechbank(entityplayer, npc);
        }
    }

    protected boolean isQuestItem(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (LOTRItemMug.isItemFullDrink(this.collectItem)) {
            ItemStack collectDrink = LOTRItemMug.getEquivalentDrink(this.collectItem);
            ItemStack offerDrink = LOTRItemMug.getEquivalentDrink(itemstack);
            return collectDrink.func_77973_b() == offerDrink.func_77973_b();
        }
        return itemstack.func_77973_b() == this.collectItem.func_77973_b() && (this.collectItem.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == this.collectItem.func_77960_j());
    }

    @Override
    public float getAlignmentBonus() {
        float f = this.collectTarget;
        return Math.max(f *= this.rewardFactor, 1.0f);
    }

    @Override
    public int getCoinBonus() {
        return Math.round(this.getAlignmentBonus() * 2.0f);
    }

    public static class QFCollect<Q extends LOTRMiniQuestCollect>
    extends LOTRMiniQuest.QuestFactoryBase<Q> {
        private ItemStack collectItem;
        private int minTarget;
        private int maxTarget;

        public QFCollect(String name) {
            super(name);
        }

        public QFCollect setCollectItem(ItemStack itemstack, int min, int max) {
            this.collectItem = itemstack;
            if (this.collectItem.func_77984_f()) {
                this.collectItem.func_77964_b(Short.MAX_VALUE);
            }
            this.minTarget = min;
            this.maxTarget = max;
            return this;
        }

        @Override
        public Class getQuestClass() {
            return LOTRMiniQuestCollect.class;
        }

        @Override
        public Q createQuest(LOTREntityNPC npc, Random rand) {
            LOTRMiniQuestCollect quest = (LOTRMiniQuestCollect)super.createQuest(npc, rand);
            quest.collectItem = this.collectItem.func_77946_l();
            quest.collectTarget = MathHelper.func_76136_a((Random)rand, (int)this.minTarget, (int)this.maxTarget);
            return (Q)quest;
        }
    }
}

